	clear all
	close all
	clc
	wcT = 0.925*pi; 	wsT = 0.9375*pi;	% Desired band edges
	Amax = 0.1;			Amin = 60; 
	M = 4; 			% Select the periodic filter with period M 	 
	% We design a lowpass filter with the band edges
	wclT = pi-wsT; 	wslT = pi-wcT;		% Lowpass band edges
	% 	The model filer has a very low passband ripple, hence, most of
	%	the ripple can be allocated to the masking filters
	dsm = (10^(Amax/20)-1)/(1+10^(Amax/20)); 	% 	Stopband ripple
	dcm = 10^(-Amin/20);			% Passband ripple for the masking filter
	AmaxG = -10*log10(1-dcm^2); 	% Passband attenuation for the model filter
	AminG = -10*log10(2*dsm); 		% Stopband attenuation for the model filter	
	% 	Find the model filter whose band edges are M times the ones given above
	NG = ceil(CA_ORDER_Z(M*wclT, M*wslT, AmaxG, AminG)) % Estimate the filter order  
	if rem(NG,2) == 0; 				% We must select an odd integer order
		NG = NG+1; 
	end
	[G, Z, R_ZEROS, P, WsnewT] = CA_POLES_Z(M*wclT, M*wslT, AmaxG, AminG, NG);	
	[Zodd, Podd, Zeven, Peven] = SORT_LATTICE_POLES_LP_Z(P);
	% 	Periodic filter
	MwT = linspace(0, M*pi, 1000); wT = linspace(0, pi, 1000);	
	%	Compute the fequency responses of the allpass sections
	[S1, S2] = LATTICE_2_H_Z(Zodd, Podd, Zeven, Peven, MwT);
	GM = (S2-S1)/2;	
	figure(1), subplot(2,1,1);  
	PLOT_MAG_Z_dB(wT, GM, pi, 90, 'G_M'); 	
	% Masking filter	
	% Design first a lowpass FIR filter
	N_F = 12; Be = [0 wclT pi/2-wslT pi/2+wslT pi-wslT pi];
	D = [1 1 0 0 0 0]; 	W = [1 dcm/dsm dcm/dsm];	
	[hLP, ErrF] = REMEZ_FIR(N_F, Be, D, W,'m');	
	hHP = LP_2_HP_FIR(hLP);	
	F = freqz(hHP,1, wT);		
	HzmK = exp(-j*(N_F/2)*wT);		% Frequency response of z^(-N_F/2)	
	subplot(2,1,2);	
	PLOT_MAG_Z_dB(wT, F, pi, 90, 'F');	
	% Verify the frequency response of the FRM filter
	figure(2), subplot('position', [0.1 0.4 0.88 0.5]);
	H = S2.*HzmK - GM.*F;
	PLOT_MAG_Z_dB(wT, H, pi, 90, 'H')
	
